/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.ponder.api.ParticleEmitter;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.zurrtum.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.LitBlazeBurnerBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3730;
import net.minecraft.class_6903;

@Environment(value=EnvType.CLIENT)
public class ProcessingScenes {
    public static void millstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("millstone", "Processing Items in the Millstone");
        scene.configureBasePlate(0, 0, 5);
        Selection belt = util.select().fromTo(1, 1, 5, 0, 1, 2).add(util.select().position(1, 2, 2));
        Selection beltCog = util.select().position(2, 0, 5);
        scene.world().showSection(util.select().layer(0).substract(beltCog), class_2350.field_11036);
        class_2338 millstone = util.grid().at(2, 2, 2);
        Selection millstoneSelect = util.select().position(2, 2, 2);
        Selection cogs = util.select().fromTo(3, 1, 2, 3, 2, 2);
        scene.world().setKineticSpeed(millstoneSelect, 0.0f);
        scene.idle(5);
        scene.world().showSection(util.select().position(4, 1, 3), class_2350.field_11033);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(millstone), class_2350.field_11033);
        scene.idle(10);
        class_243 millstoneTop = util.vector().topOf(millstone);
        scene.overlay().showText(60).attachKeyFrame().text("Millstones process items by grinding them").pointAt(millstoneTop).placeNearTarget();
        scene.idle(70);
        scene.world().showSection(cogs, class_2350.field_11033);
        scene.idle(10);
        scene.world().setKineticSpeed(millstoneSelect, 32.0f);
        scene.effects().indicateSuccess(millstone);
        scene.idle(10);
        scene.overlay().showText(60).attachKeyFrame().colored(PonderPalette.GREEN).text("They can be powered from the side using cogwheels").pointAt(util.vector().topOf(millstone.method_10078())).placeNearTarget();
        scene.idle(70);
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8861);
        class_243 entitySpawn = util.vector().topOf(millstone.method_10086(3));
        ElementLink<EntityElement> entity1 = scene.world().createItemEntity(entitySpawn, util.vector().of(0.0, 0.2, 0.0), itemStack);
        scene.idle(18);
        scene.world().modifyEntity(entity1, class_1297::method_31472);
        scene.world().modifyBlockEntity(millstone, MillstoneBlockEntity.class, ms -> {
            ms.timer = 150;
            ms.capability.method_5447(0, itemStack);
        });
        scene.idle(10);
        scene.overlay().showControls(millstoneTop, Pointing.DOWN, 30).withItem(itemStack);
        scene.idle(7);
        scene.overlay().showText(40).attachKeyFrame().text("Throw or Insert items at the top").pointAt(millstoneTop).placeNearTarget();
        scene.idle(60);
        scene.world().modifyBlockEntity(millstone, MillstoneBlockEntity.class, ms -> ms.capability.method_5447(0, class_1799.field_8037));
        scene.overlay().showText(50).text("After some time, the result can be obtained via Right-click").pointAt(util.vector().blockSurface(millstone, class_2350.field_11039)).placeNearTarget();
        scene.idle(60);
        class_1799 flour = AllItems.WHEAT_FLOUR.method_7854();
        scene.overlay().showControls(util.vector().blockSurface(millstone, class_2350.field_11043), Pointing.RIGHT, 40).rightClick().withItem(flour);
        scene.idle(50);
        scene.addKeyframe();
        scene.world().showSection(beltCog, class_2350.field_11036);
        scene.world().showSection(belt, class_2350.field_11034);
        scene.idle(15);
        class_2338 beltPos = util.grid().at(1, 1, 2);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11034, flour);
        scene.idle(15);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11034, new class_1799((class_1935)class_1802.field_8317));
        scene.idle(20);
        scene.overlay().showText(50).text("The outputs can also be extracted by automation").pointAt(util.vector().blockSurface(millstone, class_2350.field_11039).method_1031(-0.5, 0.4, 0.0)).placeNearTarget();
        scene.idle(60);
    }

    public static void crushingWheels(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("crushing_wheels", "Processing Items with Crushing Wheels");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        Selection wheels = util.select().fromTo(3, 2, 2, 1, 2, 2);
        Selection kinetics = util.select().fromTo(0, 1, 5, 4, 1, 3);
        Selection kinetics2 = util.select().fromTo(0, 2, 5, 4, 2, 3);
        Selection beltCog = util.select().position(5, 0, 1);
        scene.world().setKineticSpeed(wheels, 0.0f);
        scene.world().setBlock(util.grid().at(2, 3, 2), class_2246.field_10124.method_9564(), false);
        scene.world().showSection(util.select().layer(0).substract(beltCog), class_2350.field_11036);
        scene.idle(5);
        Selection belt = util.select().fromTo(4, 1, 2, 4, 4, 2).add(util.select().fromTo(4, 3, 3, 4, 4, 3)).add(util.select().position(3, 3, 2)).add(util.select().position(2, 3, 2));
        Selection bottomBelt = util.select().fromTo(5, 1, 0, 2, 1, 0).add(util.select().fromTo(2, 1, 2, 2, 1, 1));
        class_2338 center = util.grid().at(2, 2, 2);
        Selection wWheel = util.select().position(center.method_10067());
        Selection eWheel = util.select().position(center.method_10078());
        scene.world().showSection(wWheel, class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(eWheel, class_2350.field_11035);
        scene.idle(10);
        class_243 centerTop = util.vector().topOf(center);
        scene.overlay().showText(60).attachKeyFrame().text("A pair of Crushing Wheels can grind items very effectively").pointAt(centerTop).placeNearTarget();
        scene.idle(70);
        scene.world().showSection(kinetics, class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(kinetics2, class_2350.field_11033);
        scene.world().setKineticSpeed(wWheel, -16.0f);
        scene.world().setKineticSpeed(eWheel, 16.0f);
        scene.idle(5);
        scene.effects().rotationDirectionIndicator(center.method_10067());
        scene.effects().rotationDirectionIndicator(center.method_10078());
        scene.idle(10);
        scene.overlay().showText(60).attachKeyFrame().text("Their Rotational Input has to make them spin into each other").pointAt(util.vector().blockSurface(center.method_10067(), class_2350.field_11043)).placeNearTarget();
        scene.idle(40);
        scene.effects().rotationDirectionIndicator(center.method_10067());
        scene.effects().rotationDirectionIndicator(center.method_10078());
        scene.idle(30);
        class_1799 input = new class_1799((class_1935)class_1802.field_8775);
        class_1799 output = new class_1799((class_1935)class_1802.field_33402);
        class_243 entitySpawn = util.vector().topOf(center.method_10086(2));
        ElementLink<EntityElement> entity1 = scene.world().createItemEntity(entitySpawn, util.vector().of(0.0, 0.2, 0.0), input);
        scene.idle(18);
        scene.world().modifyEntity(entity1, class_1297::method_31472);
        ParticleEmitter blockSpace = scene.effects().particleEmitterWithinBlockSpace(new class_2392(class_2398.field_11218, input), util.vector().of(0.0, 0.0, 0.0));
        scene.effects().emitParticles(util.vector().centerOf(center).method_1031(0.0, -0.2, 0.0), blockSpace, 3.0f, 40);
        scene.idle(10);
        scene.overlay().showControls(centerTop, Pointing.DOWN, 30).withItem(input);
        scene.idle(7);
        scene.overlay().showText(50).attachKeyFrame().text("Items thrown or inserted into the top will get processed").pointAt(centerTop).placeNearTarget();
        scene.idle(60);
        scene.world().createItemEntity(centerTop.method_1031(0.0, -1.4, 0.0), util.vector().of(0.0, 0.0, 0.0), output);
        scene.idle(10);
        scene.world().createItemEntity(centerTop.method_1031(0.0, -1.4, 0.0), util.vector().of(0.0, 0.0, 0.0), output);
        scene.overlay().showControls(centerTop.method_1031(0.0, -2.0, 0.0), Pointing.UP, 30).withItem(output);
        scene.idle(40);
        scene.world().restoreBlocks(util.select().position(2, 3, 2));
        scene.world().showSection(belt, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(beltCog, class_2350.field_11036);
        scene.idle(5);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().showSection(bottomBelt, class_2350.field_11035);
        scene.idle(5);
        scene.overlay().showText(50).attachKeyFrame().text("Items can be inserted and picked up through automated means as well").pointAt(centerTop.method_1031(0.0, 0.5, 0.0)).placeNearTarget();
        scene.idle(40);
        for (int i = 0; i < 5; ++i) {
            if (i < 4) {
                scene.world().createItemOnBelt(util.grid().at(4, 4, 2), class_2350.field_11034, input);
            }
            scene.idle(15);
            if (i < 3) {
                scene.world().createItemOnBelt(util.grid().at(4, 4, 2), class_2350.field_11034, input);
            }
            scene.idle(15);
            if (i > 0) {
                scene.world().createItemOnBelt(center.method_10074(), class_2350.field_11036, output);
                scene.idle(15);
                scene.world().createItemOnBelt(center.method_10074(), class_2350.field_11036, output);
            }
            scene.world().removeItemsFromBelt(util.grid().at(3, 3, 2));
            if (i < 4) {
                scene.effects().emitParticles(util.vector().centerOf(center).method_1031(0.0, -0.2, 0.0), blockSpace, 3.0f, 28);
            }
            if (i != 0) continue;
            scene.markAsFinished();
        }
    }

    public static void pressing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_press", "Processing Items with the Mechanical Press");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        ElementLink<WorldSectionElement> depot = scene.world().showIndependentSection(util.select().position(2, 1, 1), class_2350.field_11033);
        scene.world().moveSection(depot, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection pressS = util.select().position(2, 3, 2);
        class_2338 pressPos = util.grid().at(2, 3, 2);
        class_2338 depotPos = util.grid().at(2, 1, 1);
        scene.world().setKineticSpeed(pressS, 0.0f);
        scene.world().showSection(pressS, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11043);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 2, 3), class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 3, 3), class_2350.field_11043);
        scene.world().setKineticSpeed(pressS, -32.0f);
        scene.effects().indicateSuccess(pressPos);
        scene.idle(10);
        class_243 pressSide = util.vector().blockSurface(pressPos, class_2350.field_11039);
        scene.overlay().showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Mechanical Press can process items provided beneath it");
        scene.idle(70);
        scene.overlay().showText(60).pointAt(pressSide.method_1023(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Press");
        scene.idle(50);
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, copper);
        class_243 depotCenter = util.vector().centerOf(depotPos.method_10072());
        scene.overlay().showControls(depotCenter, Pointing.UP, 30).withItem(copper);
        scene.idle(10);
        Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world().removeItemsFromBelt(depotPos);
        class_1799 sheet = AllItems.COPPER_SHEET.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11036, sheet);
        scene.idle(10);
        scene.overlay().showControls(depotCenter, Pointing.UP, 50).withItem(sheet);
        scene.idle(60);
        scene.world().hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 0, 2, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 beltPos = util.grid().at(0, 1, 2);
        scene.overlay().showText(40).pointAt(util.vector().blockSurface(beltPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink<BeltItemElement> ingot = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, copper);
        scene.idle(15);
        ElementLink<BeltItemElement> ingot2 = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, copper);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, true);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.overlay().showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Press will hold and process them automatically");
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world().removeItemsFromBelt(pressPos.method_10087(2));
        ingot = scene.world().createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, sheet);
        scene.world().stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, true);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world().removeItemsFromBelt(pressPos.method_10087(2));
        ingot2 = scene.world().createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, sheet);
        scene.world().stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, false);
    }

    public static void mixing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_mixer", "Processing Items with the Mechanical Mixer");
        scene.configureBasePlate(0, 0, 5);
        scene.world().setBlock(util.grid().at(1, 1, 2), AllBlocks.ANDESITE_CASING.method_9564(), false);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 1, 1, 5), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 4, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 1, 1, 1), class_2350.field_11035);
        scene.world().showSection(util.select().fromTo(3, 1, 5, 3, 1, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 basin = util.grid().at(1, 2, 2);
        class_2338 pressPos = util.grid().at(1, 4, 2);
        class_243 basinSide = util.vector().blockSurface(basin, class_2350.field_11039);
        class_1799 blue = new class_1799((class_1935)class_1802.field_8345);
        class_1799 red = new class_1799((class_1935)class_1802.field_8264);
        class_1799 purple = new class_1799((class_1935)class_1802.field_8296);
        scene.overlay().showText(60).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("With a Mixer and Basin, some Crafting Recipes can be automated");
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.LEFT, 30).withItem(blue);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.RIGHT, 30).withItem(red);
        scene.idle(30);
        Class<MechanicalMixerBlockEntity> type = MechanicalMixerBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, MechanicalMixerBlockEntity::startProcessingBasin);
        scene.world().createItemOnBeltLike(basin, class_2350.field_11036, red);
        scene.world().createItemOnBeltLike(basin, class_2350.field_11036, blue);
        scene.idle(80);
        scene.world().modifyBlockEntityNBT(util.select().position(basin), BasinBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            class_2499 list = new class_2499();
            list.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)purple).getOrThrow()));
            nbt.method_10566("VisualizedItems", (class_2520)list);
        });
        scene.idle(4);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 1), class_2350.field_11036, purple);
        scene.idle(30);
        scene.overlay().showText(80).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Available recipes include any Shapeless Crafting Recipe, plus a couple extra ones");
        scene.idle(80);
        scene.rotateCameraY(-30.0f);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(1, 1, 2), (class_2680)AllBlocks.BLAZE_BURNER.method_9564().method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), true);
        scene.idle(10);
        scene.overlay().showText(80).pointAt(basinSide.method_1023(0.0, 1.0, 0.0)).placeNearTarget().text("Some of those recipes may require the heat of a Blaze Burner");
        scene.idle(40);
        scene.rotateCameraY(30.0f);
        scene.idle(60);
        class_243 filterPos = util.vector().of(1.0, 2.75, 2.5);
        scene.overlay().showFilterSlotInput(filterPos, class_2350.field_11039, 100);
        scene.overlay().showText(100).pointAt(filterPos).placeNearTarget().attachKeyFrame().text("The filter slot can be used in case two recipes are conflicting.");
        scene.idle(80);
    }

    public static void compacting(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_press_compacting", "Compacting items with the Mechanical Press");
        scene.configureBasePlate(0, 0, 5);
        scene.world().setBlock(util.grid().at(1, 1, 2), AllBlocks.ANDESITE_CASING.method_9564(), false);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 1, 1, 5), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 4, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 1, 1, 1), class_2350.field_11035);
        scene.world().showSection(util.select().fromTo(3, 1, 5, 3, 1, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 basin = util.grid().at(1, 2, 2);
        class_2338 pressPos = util.grid().at(1, 4, 2);
        class_243 basinSide = util.vector().blockSurface(basin, class_2350.field_11039);
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022);
        class_1799 copperBlock = new class_1799((class_1935)class_1802.field_27071);
        scene.overlay().showText(60).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Pressing items held in a Basin will cause them to be Compacted");
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.DOWN, 30).withItem(copper);
        scene.idle(30);
        Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makeCompactingParticleEffect(util.vector().centerOf(basin), copper));
        scene.world().modifyBlockEntityNBT(util.select().position(basin), BasinBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            class_2499 list = new class_2499();
            list.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)copperBlock).getOrThrow()));
            nbt.method_10566("VisualizedItems", (class_2520)list);
        });
        scene.idle(4);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 1), class_2350.field_11036, copperBlock);
        scene.idle(30);
        scene.overlay().showText(80).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("Compacting includes any filled 2x2 or 3x3 Crafting Recipe, plus a couple extra ones");
        scene.idle(30);
        class_1799 log = new class_1799((class_1935)class_1802.field_8583);
        class_1799 bark = new class_1799((class_1935)class_1802.field_8888);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.DOWN, 30).withItem(log);
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makeCompactingParticleEffect(util.vector().centerOf(basin), log));
        scene.world().modifyBlockEntityNBT(util.select().position(basin), BasinBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            class_2499 list = new class_2499();
            list.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)bark).getOrThrow()));
            nbt.method_10566("VisualizedItems", (class_2520)list);
        });
        scene.idle(4);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 1), class_2350.field_11036, bark);
        scene.idle(30);
        scene.rotateCameraY(-30.0f);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(1, 1, 2), (class_2680)AllBlocks.BLAZE_BURNER.method_9564().method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), true);
        scene.idle(10);
        scene.overlay().showText(80).pointAt(basinSide.method_1023(0.0, 1.0, 0.0)).placeNearTarget().text("Some of those recipes may require the heat of a Blaze Burner");
        scene.idle(40);
        scene.rotateCameraY(30.0f);
        scene.idle(60);
        class_243 filterPos = util.vector().of(1.0, 2.75, 2.5);
        scene.overlay().showFilterSlotInput(filterPos, class_2350.field_11039, 100);
        scene.overlay().showText(100).pointAt(filterPos).placeNearTarget().attachKeyFrame().text("The filter slot can be used in case two recipes are conflicting.");
        scene.idle(80);
    }

    public static void emptyBlazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("empty_blaze_burner", "Using Empty Blaze Burners");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(10);
        class_2338 center = util.grid().at(2, 0, 2);
        scene.world().createEntity(w -> {
            class_1545 blazeEntity = (class_1545)class_1299.field_6099.method_5883(w, class_3730.field_52444);
            class_243 v = util.vector().topOf(center);
            blazeEntity.method_23327(v.field_1352, v.field_1351, v.field_1350);
            blazeEntity.field_5982 = 180.0f;
            blazeEntity.method_36456(180.0f);
            return blazeEntity;
        });
        scene.idle(20);
        scene.overlay().showControls(util.vector().centerOf(center.method_10086(2)), Pointing.DOWN, 40).rightClick().withItem(AllItems.EMPTY_BLAZE_BURNER.method_7854());
        scene.idle(10);
        scene.overlay().showText(60).text("Right-click a Blaze with the empty burner to capture it").attachKeyFrame().pointAt(util.vector().blockSurface(center.method_10086(2), class_2350.field_11039)).placeNearTarget();
        scene.idle(50);
        scene.world().modifyEntities(class_1545.class, class_1297::method_31472);
        scene.idle(20);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(center.method_10084()), Pointing.DOWN, 40).rightClick().withItem(AllItems.EMPTY_BLAZE_BURNER.method_7854());
        scene.idle(10);
        scene.overlay().showText(60).text("Alternatively, Blazes can be collected from their Spawners directly").attachKeyFrame().pointAt(util.vector().blockSurface(center.method_10084(), class_2350.field_11039)).placeNearTarget();
        scene.idle(50);
        scene.world().hideSection(util.select().position(2, 1, 2), class_2350.field_11036);
        scene.idle(20);
        scene.world().showSection(util.select().position(1, 1, 2), class_2350.field_11033);
        scene.idle(20);
        scene.world().modifyBlock(util.grid().at(1, 1, 2), s -> (class_2680)s.method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), false);
        scene.overlay().showText(70).text("You now have an ideal heat source for various machines").attachKeyFrame().pointAt(util.vector().blockSurface(center.method_10067().method_10084(), class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().position(3, 1, 2), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(center.method_10078().method_10084()), Pointing.DOWN, 40).rightClick().withItem(new class_1799((class_1935)class_1802.field_8884));
        scene.idle(7);
        scene.world().setBlock(util.grid().at(3, 1, 2), AllBlocks.LIT_BLAZE_BURNER.method_9564(), false);
        scene.idle(10);
        scene.overlay().showText(70).text("For Aesthetic purposes, Empty Blaze Burners can also be lit using Flint and Steel").attachKeyFrame().pointAt(util.vector().blockSurface(center.method_10078().method_10084(), class_2350.field_11036)).placeNearTarget();
        scene.idle(80);
        scene.overlay().showControls(util.vector().topOf(center.method_10078().method_10084()), Pointing.DOWN, 40).rightClick().withItem(new class_1799((class_1935)class_1802.field_8067));
        scene.idle(7);
        scene.world().modifyBlock(util.grid().at(3, 1, 2), s -> (class_2680)s.method_11657(LitBlazeBurnerBlock.FLAME_TYPE, (Comparable)((Object)LitBlazeBurnerBlock.FlameType.SOUL)), false);
        scene.overlay().showText(60).text("The flame can be transformed using a soul-infused item").pointAt(util.vector().blockSurface(center.method_10078().method_10084(), class_2350.field_11036)).placeNearTarget();
        scene.idle(80);
        scene.overlay().showText(90).colored(PonderPalette.RED).text("However, without a blaze they are not suitable for industrial heating").pointAt(util.vector().blockSurface(center.method_10078().method_10084(), class_2350.field_11036)).placeNearTarget();
        scene.idle(70);
    }

    public static void blazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("blaze_burner", "Feeding Blaze Burners");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        class_2338 burner = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(burner), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(burner.method_10084()), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(70).attachKeyFrame().text("Blaze Burners can provide Heat to Items processed in a Basin").pointAt(util.vector().blockSurface(burner, class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        scene.world().hideSection(util.select().position(burner.method_10084()), class_2350.field_11036);
        scene.idle(20);
        scene.world().setBlock(burner.method_10084(), class_2246.field_10124.method_9564(), false);
        scene.overlay().showControls(util.vector().topOf(burner), Pointing.DOWN, 15).rightClick().withItem(new class_1799((class_1935)class_1802.field_8118));
        scene.idle(7);
        scene.world().modifyBlock(burner, s -> (class_2680)s.method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.KINDLED)), false);
        scene.idle(20);
        scene.overlay().showText(70).attachKeyFrame().text("For this, the Blaze has to be fed with flammable items").pointAt(util.vector().blockSurface(burner, class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(burner), Pointing.DOWN, 30).rightClick().withItem(AllItems.BLAZE_CAKE.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(burner, s -> (class_2680)s.method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.SEETHING)), false);
        scene.idle(20);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.MEDIUM).text("With a Blaze Cake, the Burner can reach an even stronger level of heat").pointAt(util.vector().blockSurface(burner, class_2350.field_11039)).placeNearTarget();
        scene.idle(90);
        Class<DeployerBlockEntity> teType = DeployerBlockEntity.class;
        scene.world().modifyBlockEntityNBT(util.select().position(4, 1, 2), teType, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            nbt.method_67493("HeldItem", class_1799.field_24671, (DynamicOps)ops, (Object)AllItems.BLAZE_CAKE.method_7854());
        });
        scene.world().showSection(util.select().fromTo(3, 0, 5, 2, 0, 5), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 4, 1, 5), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(2, 1, 4, 2, 1, 5), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().text("The feeding process can be automated using Deployers or Mechanical Arms").pointAt(util.vector().blockSurface(burner.method_10089(2), class_2350.field_11036));
        scene.idle(90);
    }

    public static void basin(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basin", "Processing Items in the Basin");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 2), class_2350.field_11033);
        scene.idle(10);
        class_2338 basinPos = util.grid().at(1, 2, 2);
        scene.world().modifyBlock(basinPos, s -> (class_2680)s.method_11657(BasinBlock.FACING, (Comparable)class_2350.field_11033), false);
        scene.world().showSection(util.select().position(basinPos), class_2350.field_11033);
        scene.idle(10);
        class_243 basinSide = util.vector().blockSurface(basinPos, class_2350.field_11039);
        scene.overlay().showText(80).attachKeyFrame().text("A Basin can hold Items and Fluids for Processing").pointAt(basinSide).placeNearTarget();
        scene.idle(10);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8621);
        for (int i = 0; i < 4; ++i) {
            scene.world().createItemEntity(util.vector().centerOf(basinPos.method_10086(3)), util.vector().of(0.0, 0.0, 0.0), stack);
            scene.idle(10);
        }
        scene.idle(10);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.DOWN, 30).withItem(stack);
        scene.idle(30);
        for (class_2350 d : Iterate.horizontalDirections) {
            scene.overlay().showOutline(PonderPalette.GREEN, new Object(), util.select().position(basinPos.method_10074().method_10093(d)), 60);
            scene.idle(4);
        }
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("After a processing step, basins try to output below to the side of them").pointAt(basinSide).placeNearTarget();
        scene.idle(90);
        ElementLink<WorldSectionElement> depot = scene.world().showIndependentSection(util.select().position(3, 1, 1), class_2350.field_11034);
        scene.world().moveSection(depot, util.vector().of(-2.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.world().modifyBlock(basinPos, s -> (class_2680)s.method_11657(BasinBlock.FACING, (Comparable)class_2350.field_11043), false);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("When a valid component is present, the Basin will show an output faucet").pointAt(basinSide.method_1031(0.15, 0.0, -0.5)).placeNearTarget();
        scene.idle(90);
        scene.world().hideIndependentSection(depot, class_2350.field_11034);
        scene.idle(15);
        depot = scene.world().showIndependentSection(util.select().position(0, 1, 1), class_2350.field_11034);
        scene.world().moveSection(depot, util.vector().of(1.0, 0.0, 0.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(depot, class_2350.field_11034);
        scene.overlay().showText(80).text("A number of options are applicable here").pointAt(util.vector().centerOf(util.grid().at(1, 1, 1))).placeNearTarget();
        scene.idle(15);
        depot = scene.world().showIndependentSection(util.select().position(1, 1, 0), class_2350.field_11034);
        scene.world().moveSection(depot, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(depot, class_2350.field_11034);
        scene.idle(15);
        depot = scene.world().showIndependentSection(util.select().position(1, 1, 1), class_2350.field_11034);
        scene.idle(20);
        scene.world().hideIndependentSection(depot, class_2350.field_11034);
        scene.idle(15);
        depot = scene.world().showIndependentSection(util.select().fromTo(3, 1, 0, 2, 1, 0), class_2350.field_11034);
        scene.world().moveSection(depot, util.vector().of(-2.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(depot, class_2350.field_11034);
        scene.idle(15);
        depot = scene.world().showIndependentSection(util.select().position(2, 1, 1), class_2350.field_11034);
        scene.world().moveSection(depot, util.vector().of(-1.0, 0.0, 0.0), 0);
        scene.idle(25);
        class_2338 pressPos = util.grid().at(1, 4, 2);
        scene.world().showSection(util.select().position(pressPos), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 1, 1, 5), class_2350.field_11043);
        scene.idle(10);
        Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makeCompactingParticleEffect(util.vector().centerOf(basinPos), stack));
        scene.world().modifyBlockEntityNBT(util.select().position(basinPos), BasinBlockEntity.class, nbt -> {
            class_6903 ops = scene.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            class_2499 list = new class_2499();
            list.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)new class_1799((class_1935)class_2246.field_10104)).getOrThrow()));
            nbt.method_10566("VisualizedItems", (class_2520)list);
        });
        scene.idle(4);
        scene.overlay().showControls(util.vector().topOf(basinPos.method_10074().method_10095()), Pointing.RIGHT, 30).withItem(new class_1799((class_1935)class_1802.field_20390));
        scene.overlay().showText(60).attachKeyFrame().colored(PonderPalette.GREEN).text("Outputs will be caught by the inventory below").pointAt(basinSide.method_1031(0.0, -1.0, -1.0)).placeNearTarget();
        scene.idle(70);
        scene.world().hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(10);
        scene.world().modifyBlock(basinPos, s -> (class_2680)s.method_11657(BasinBlock.FACING, (Comparable)class_2350.field_11033), false);
        scene.idle(20);
        scene.overlay().showText(80).attachKeyFrame().text("Without output faucet, the Basin will retain items created in its processing").pointAt(basinSide).placeNearTarget();
        scene.idle(50);
        class_1799 nugget = class_1802.field_61349.method_7854();
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).withItem(nugget);
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makeCompactingParticleEffect(util.vector().centerOf(basinPos), nugget));
        class_1799 ingot = new class_1799((class_1935)class_1802.field_27022);
        scene.idle(30);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).withItem(ingot);
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
        scene.idle(30);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makeCompactingParticleEffect(util.vector().centerOf(basinPos), ingot));
        class_1799 block = new class_1799((class_1935)class_1802.field_27071);
        scene.idle(30);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).withItem(block);
        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.GREEN).text("This can be useful if outputs should be re-used as ingredients").pointAt(basinSide).placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().fromTo(2, 2, 5, 4, 1, 2), class_2350.field_11033);
        scene.rotateCameraY(70.0f);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 2), class_2350.field_11039, block);
        scene.idle(40);
        scene.overlay().showText(70).text("Desired outputs will then have to be extracted from the basin").pointAt(util.vector().topOf(util.grid().at(3, 1, 2)).method_1023(0.0, 0.1875, 0.0)).placeNearTarget();
        scene.idle(80);
        class_243 filter = util.vector().of(2.5, 2.825, 2.5);
        scene.overlay().showFilterSlotInput(filter, class_2350.field_11034, 80);
        scene.overlay().showText(70).text("A Filter might be necessary to avoid pulling out un-processed items").pointAt(filter).placeNearTarget();
        scene.idle(40);
        scene.markAsFinished();
    }
}

